﻿''' <summary>
''' 为 CRM 系统定义的所有异常的基异常。
''' </summary>
''' <remarks></remarks>
Public Class CRMSystemException
    Inherits System.ApplicationException

    Private appSourceValue As String

    Public Sub New(ByVal Message As String)
        MyBase.New(Message)
        Me.appSourceValue = "Tailspin Toys CRM System"
    End Sub

    ''' <summary>
    ''' 记录错误
    ''' </summary>
    ''' <remarks></remarks>
    Friend Sub LogError()
        My.Application.Log.WriteEntry(Me.Message)
    End Sub

    ''' <summary>
    ''' 异常的源（公司）
    ''' </summary>
    Public Overridable ReadOnly Property AppSource() As String
        Get
            Return appSourceValue
        End Get
    End Property
End Class